/*
 * Decompiled with CFR 0.152.
 */
package spire.random;

import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import spire.random.Generator;

public final class Ziggurat$ {
    public static Ziggurat$ MODULE$;
    private final long[] kn;
    private final double[] wn;
    private final double[] fn;
    private final long[] ke;
    private final double[] we;
    private final double[] fe;

    static {
        new Ziggurat$();
    }

    private long[] kn() {
        return this.kn;
    }

    private double[] wn() {
        return this.wn;
    }

    private double[] fn() {
        return this.fn;
    }

    private long[] ke() {
        return this.ke;
    }

    private double[] we() {
        return this.we;
    }

    private double[] fe() {
        return this.fe;
    }

    public double rnor(Generator g) {
        int hz = g.nextInt();
        int iz = hz & 0x7F;
        return (long)package$.MODULE$.abs(hz) < this.kn()[iz] ? (double)hz * this.wn()[iz] : this.nfix(g, hz, iz);
    }

    public double rexp(Generator g) {
        long jz = (long)g.nextInt() & 0xFFFFFFFFL;
        int iz = (int)(jz & 0xFFL);
        return jz < this.ke()[iz] ? (double)jz * this.we()[iz] : this.efix(g, jz, iz);
    }

    private double nfix(Generator g, int hza, int iza) {
        double r = 3.442619855899;
        double r1 = 1.0 / r;
        DoubleRef x = DoubleRef.create(0.0);
        DoubleRef y = DoubleRef.create(0.0);
        IntRef hz = IntRef.create(hza);
        IntRef iz = IntRef.create(iza);
        return this.loop$1(g, r, r1, x, y, hz, iz);
    }

    private double efix(Generator g, long jza, int iza) {
        LongRef jz = LongRef.create(jza);
        IntRef iz = IntRef.create(iza);
        return this.loop$2(g, jz, iz);
    }

    private final double loop$1(Generator g$1, double r$1, double r1$1, DoubleRef x$1, DoubleRef y$1, IntRef hz$1, IntRef iz$1) {
        do {
            x$1.elem = (double)hz$1.elem * this.wn()[iz$1.elem];
            if (iz$1.elem == 0) {
                do {
                    x$1.elem = -package$.MODULE$.log(g$1.nextDouble()) * r1$1;
                    y$1.elem = -package$.MODULE$.log(g$1.nextDouble());
                } while (y$1.elem + y$1.elem < x$1.elem * x$1.elem);
                return hz$1.elem > 0 ? r$1 + x$1.elem : -r$1 - x$1.elem;
            }
            if (this.fn()[iz$1.elem] + g$1.nextDouble() * (this.fn()[iz$1.elem - 1] - this.fn()[iz$1.elem]) < package$.MODULE$.exp(-0.5 * x$1.elem * x$1.elem)) {
                return x$1.elem;
            }
            hz$1.elem = g$1.nextInt();
            iz$1.elem = hz$1.elem & 0x7F;
        } while ((long)package$.MODULE$.abs(hz$1.elem) >= this.kn()[iz$1.elem]);
        return (double)hz$1.elem * this.wn()[iz$1.elem];
    }

    private final double loop$2(Generator g$2, LongRef jz$1, IntRef iz$2) {
        do {
            if (iz$2.elem == 0) {
                return 7.697117470131487 - package$.MODULE$.log(g$2.nextDouble());
            }
            double x = (double)jz$1.elem * this.we()[iz$2.elem];
            if (this.fe()[iz$2.elem] + g$2.nextDouble() * (this.fe()[iz$2.elem - 1] - this.fe()[iz$2.elem]) < package$.MODULE$.exp(-x)) {
                return x;
            }
            jz$1.elem = (long)g$2.nextInt() & 0xFFFFFFFFL;
            iz$2.elem = (int)(jz$1.elem & 0xFFL);
        } while (jz$1.elem >= this.ke()[iz$2.elem]);
        return (double)jz$1.elem * this.we()[iz$2.elem];
    }

    private Ziggurat$() {
        MODULE$ = this;
        this.kn = new long[128];
        this.wn = new double[128];
        this.fn = new double[128];
        this.ke = new long[256];
        this.we = new double[256];
        this.fe = new double[256];
        double m1 = 2.147483648E9;
        double m2 = 4.294967296E9;
        DoubleRef dn = DoubleRef.create(3.442619855899);
        DoubleRef tn = DoubleRef.create(dn.elem);
        DoubleRef de = DoubleRef.create(7.697117470131487);
        DoubleRef te = DoubleRef.create(de.elem);
        double vn = 0.00991256303526217;
        double ve = 0.003949659822581572;
        double q = vn / package$.MODULE$.exp(-0.5 * dn.elem * dn.elem);
        this.kn()[0] = (long)(dn.elem / q * m1);
        this.kn()[1] = 0L;
        this.wn()[0] = q / m1;
        this.wn()[127] = dn.elem / m1;
        this.fn()[0] = 1.0;
        this.fn()[127] = package$.MODULE$.exp(-0.5 * dn.elem * dn.elem);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(126), 1).by(-1).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)i -> {
            dn$1.elem = package$.MODULE$.sqrt((double)-2 * package$.MODULE$.log(vn / dn$1.elem + package$.MODULE$.exp(-0.5 * dn$1.elem * dn$1.elem)));
            $this.kn()[i + 1] = (long)(dn$1.elem / tn$1.elem * m1);
            tn$1.elem = dn$1.elem;
            $this.fn()[i] = package$.MODULE$.exp(-0.5 * dn$1.elem * dn$1.elem);
            $this.wn()[i] = dn$1.elem / m1;
        });
        q = ve / package$.MODULE$.exp(-de.elem);
        this.ke()[0] = (long)(de.elem / q * m2);
        this.ke()[1] = 0L;
        this.we()[0] = q / m2;
        this.we()[255] = de.elem / m2;
        this.fe()[0] = 1.0;
        this.fe()[255] = package$.MODULE$.exp(-de.elem);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(254), 1).by(-1).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)i -> {
            de$1.elem = -package$.MODULE$.log(ve / de$1.elem + package$.MODULE$.exp(-de$1.elem));
            $this.ke()[i + 1] = (long)(de$1.elem / te$1.elem * m2);
            te$1.elem = de$1.elem;
            $this.fe()[i] = package$.MODULE$.exp(-de$1.elem);
            $this.we()[i] = de$1.elem / m2;
        });
    }
}

