/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.serialization;

import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.syntax.package$EncoderOps$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBox$;
import org.ergoplatform.settings.ErgoAlgos$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.generic.Growable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.collection.mutable.WrappedArray$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalan.RType;
import scalan.RType$;
import scorex.util.package$;
import scorex.util.package$ByteArrayOps$;
import scorex.util.package$ModifierIdOps$;
import sigmastate.SAvlTree$;
import sigmastate.SBigInt$;
import sigmastate.SBoolean$;
import sigmastate.SBox$;
import sigmastate.SByte$;
import sigmastate.SCollectionType;
import sigmastate.SGroupElement$;
import sigmastate.SInt$;
import sigmastate.SLong$;
import sigmastate.SOption;
import sigmastate.SShort$;
import sigmastate.SSigmaProp$;
import sigmastate.SString$;
import sigmastate.STuple;
import sigmastate.STuple$;
import sigmastate.SType;
import sigmastate.SUnit$;
import sigmastate.Values;
import sigmastate.Values$Constant$;
import sigmastate.eval.Evaluation$;
import sigmastate.lang.SigmaParser$;
import sigmastate.lang.exceptions.SerializerException;
import sigmastate.lang.exceptions.SerializerException$;
import sigmastate.serialization.DataSerializer$;
import sigmastate.serialization.ErgoTreeSerializer$;
import sigmastate.serialization.SigmaSerializer$;
import sigmastate.utils.SigmaByteReader;
import sigmastate.utils.SigmaByteWriter;
import special.collection.Coll;
import special.sigma.AnyValue;
import special.sigma.BigInt;
import special.sigma.Box;
import special.sigma.TestValue;

public final class DataJsonEncoder$ {
    public static DataJsonEncoder$ MODULE$;

    static {
        new DataJsonEncoder$();
    }

    public <T extends SType> Json encode(Object v, T tpe) {
        String encodedType = tpe.toTermString();
        Json encodedData = this.encodeData(v, tpe);
        return Json$.MODULE$.obj(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("type"), Json$.MODULE$.fromString(encodedType)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("value"), encodedData)}));
    }

    private Encoder<byte[]> encodeBytes() {
        return Encoder$.MODULE$.instance((Function1<byte[], Json> & Serializable & scala.Serializable)bytes -> package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(ErgoAlgos$.MODULE$.encode((byte[])bytes)), Encoder$.MODULE$.encodeString()));
    }

    public Json encodeAnyValue(AnyValue v) {
        SType encodedType = Evaluation$.MODULE$.rtypeToSType(v.tVal());
        Json encodedData = this.encodeData(v.value(), encodedType);
        return Json$.MODULE$.obj(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("type"), Json$.MODULE$.fromString(encodedType.toTermString())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("value"), encodedData)}));
    }

    private <T extends SType> Json encodeData(Object v, T tpe) {
        Json json;
        T t = tpe;
        if (SUnit$.MODULE$.equals(t)) {
            json = Json$.MODULE$.fromFields(WrappedArray$.MODULE$.empty());
        } else if (SBoolean$.MODULE$.equals(t)) {
            json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(v))), Encoder$.MODULE$.encodeBoolean());
        } else if (SByte$.MODULE$.equals(t)) {
            json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(BoxesRunTime.boxToByte(BoxesRunTime.unboxToByte(v))), Encoder$.MODULE$.encodeByte());
        } else if (SShort$.MODULE$.equals(t)) {
            json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(BoxesRunTime.boxToShort(BoxesRunTime.unboxToShort(v))), Encoder$.MODULE$.encodeShort());
        } else if (SInt$.MODULE$.equals(t)) {
            json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(v))), Encoder$.MODULE$.encodeInt());
        } else if (SLong$.MODULE$.equals(t)) {
            json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(BoxesRunTime.boxToLong(BoxesRunTime.unboxToLong(v))), Encoder$.MODULE$.encodeLong());
        } else if (SBigInt$.MODULE$.equals(t)) {
            json = this.encodeBytes().apply(((BigInt)v).toBytes().toArray$mcB$sp());
        } else if (SString$.MODULE$.equals(t)) {
            json = this.encodeBytes().apply(((String)v).getBytes());
        } else if (t instanceof SCollectionType) {
            Json json2;
            SCollectionType sCollectionType = (SCollectionType)t;
            Coll coll = (Coll)v;
            Object t2 = sCollectionType.elemType();
            if (t2 instanceof STuple) {
                STuple sTuple = (STuple)t2;
                SType[] tArr = (SType[])sTuple.items().toArray(ClassTag$.MODULE$.apply(SType.class));
                if (tArr.length != 2) {
                    throw new SerializerException("Tuples with length not equal to 2 are not supported", SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
                }
                RType[] rtypeArr = (RType[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])tArr)).map((Function1<SType, RType> & Serializable & scala.Serializable)x -> Evaluation$.MODULE$.stypeToRType(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RType.class)));
                ArrayBuilder leftSource = ArrayBuilder$.MODULE$.make(rtypeArr[0].classTag());
                ArrayBuilder rightSource = ArrayBuilder$.MODULE$.make(rtypeArr[1].classTag());
                for (int index$macro$1 = 0; index$macro$1 < coll.length(); ++index$macro$1) {
                    Coll<Object> arr = Evaluation$.MODULE$.fromDslTuple(coll.apply(index$macro$1), sTuple);
                    leftSource.$plus$eq(arr.apply(0));
                    rightSource.$plus$eq(arr.apply(1));
                }
                Coll left = sigmastate.eval.package$.MODULE$.Colls().fromArray(leftSource.result(), rtypeArr[0]);
                SCollectionType<SType> leftType = new SCollectionType<SType>(tArr[0]);
                Coll right = sigmastate.eval.package$.MODULE$.Colls().fromArray(rightSource.result(), rtypeArr[1]);
                SCollectionType<SType> rightType = new SCollectionType<SType>(tArr[1]);
                json2 = Json$.MODULE$.fromFields(new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("_1"), this.encodeData(left, leftType))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("_2"), this.encodeData(right, rightType))), Nil$.MODULE$)));
            } else {
                MutableList jsons = (MutableList)MutableList$.MODULE$.empty();
                for (int index$macro$2 = 0; index$macro$2 < coll.length(); ++index$macro$2) {
                    Object x2 = coll.apply(index$macro$2);
                    jsons.$plus$eq(this.encodeData(x2, sCollectionType.elemType()));
                }
                json2 = Json$.MODULE$.fromValues(jsons.toList());
            }
            json = json2;
        } else if (t instanceof SOption) {
            Json json3;
            SOption sOption = (SOption)t;
            Option opt = (Option)v;
            if (opt.isDefined()) {
                Json valueJson = this.encodeData(opt.get(), (T)sOption.elemType());
                json3 = Json$.MODULE$.fromValues(Predef$.MODULE$.wrapRefArray((Object[])new Json[]{valueJson}));
            } else {
                json3 = Json$.MODULE$.Null();
            }
            json = json3;
        } else if (t instanceof STuple) {
            STuple sTuple = (STuple)t;
            Coll<Object> arr = Evaluation$.MODULE$.fromDslTuple(v, sTuple);
            SType[] tArr = (SType[])sTuple.items().toArray(ClassTag$.MODULE$.apply(SType.class));
            if (tArr.length != 2) {
                throw new SerializerException("Tuples with length not equal to 2 are not supported", SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
            }
            int len = arr.length();
            Predef$.MODULE$.assert(len == tArr.length, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Type ").append(sTuple).append(" doesn't correspond to value ").append(arr).toString());
            MutableList obj = (MutableList)MutableList$.MODULE$.empty();
            for (int index$macro$3 = 0; index$macro$3 < len; ++index$macro$3) {
                obj.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringBuilder(1).append("_").append(index$macro$3 + 1).toString()), this.encodeData(arr.apply(index$macro$3), tArr[index$macro$3])));
            }
            json = Json$.MODULE$.fromFields(obj.toList());
        } else if (SGroupElement$.MODULE$.equals(t)) {
            SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
            DataSerializer$.MODULE$.serialize(v, tpe, w);
            json = this.encodeBytes().apply(w.toBytes());
        } else if (SAvlTree$.MODULE$.equals(t)) {
            SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
            DataSerializer$.MODULE$.serialize(v, tpe, w);
            json = this.encodeBytes().apply(w.toBytes());
        } else if (SSigmaProp$.MODULE$.equals(t)) {
            SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
            DataSerializer$.MODULE$.serialize(v, tpe, w);
            json = this.encodeBytes().apply(w.toBytes());
        } else if (SBox$.MODULE$.equals(t)) {
            Box ergoBox = (Box)v;
            ObjectRef<MutableList> obj = ObjectRef.create((MutableList)MutableList$.MODULE$.empty());
            ((MutableList)obj.elem).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("value"), this.encodeData(BoxesRunTime.boxToLong(ergoBox.value()), SLong$.MODULE$)));
            ((MutableList)obj.elem).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ergoTree"), this.encodeBytes().apply(ErgoTreeSerializer$.MODULE$.DefaultSerializer().serializeErgoTree(sigmastate.eval.package$.MODULE$.boxToErgoBox(ergoBox).ergoTree()))));
            ((MutableList)obj.elem).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("tokens"), this.encodeData(sigmastate.eval.package$.MODULE$.boxToErgoBox(ergoBox).additionalTokens().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                byte[] id = (byte[])tuple2._1();
                long amount = tuple2._2$mcJ$sp();
                Tuple2<Coll<Object>, Long> tuple22 = new Tuple2<Coll<Object>, Long>(sigmastate.eval.package$.MODULE$.Colls().fromArray$mBc$sp(id, RType$.MODULE$.ByteType()), BoxesRunTime.boxToLong(amount));
                return tuple22;
            }, RType$.MODULE$.pairRType(special.collection.package$.MODULE$.collRType(RType$.MODULE$.ByteType()), RType$.MODULE$.LongType())), new SCollectionType<STuple>(STuple$.MODULE$.apply((Seq<SType>)Predef$.MODULE$.wrapRefArray((Object[])new SType[]{new SCollectionType<SByte$>(SByte$.MODULE$), SLong$.MODULE$}))))));
            sigmastate.eval.package$.MODULE$.boxToErgoBox(ergoBox).additionalRegisters().foreach((Function1<Tuple2, MutableList> & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                ErgoBox.NonMandatoryRegisterId id = (ErgoBox.NonMandatoryRegisterId)tuple2._1();
                Values.EvaluatedValue value = (Values.EvaluatedValue)tuple2._2();
                Growable growable = ((MutableList)obj$1.elem).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringBuilder(1).append("r").append(id.number()).toString()), MODULE$.encode(value.value(), (SType)value.tpe())));
                return growable;
            });
            ((MutableList)obj.elem).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("txId"), this.encodeBytes().apply(package$ModifierIdOps$.MODULE$.toBytes$extension(package$.MODULE$.ModifierIdOps(sigmastate.eval.package$.MODULE$.boxToErgoBox(ergoBox).transactionId())))));
            ((MutableList)obj.elem).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("index"), this.encodeData(BoxesRunTime.boxToShort(sigmastate.eval.package$.MODULE$.boxToErgoBox(ergoBox).index()), SShort$.MODULE$)));
            ((MutableList)obj.elem).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("creationHeight"), this.encodeData(BoxesRunTime.boxToInteger(sigmastate.eval.package$.MODULE$.boxToErgoBox(ergoBox).creationHeight()), SInt$.MODULE$)));
            json = Json$.MODULE$.fromFields((MutableList)obj.elem);
        } else {
            throw new SerializerException(new StringBuilder(36).append("Not defined DataSerializer for type ").append(t).toString(), SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
        }
        return json;
    }

    private byte[] decodeBytes(Json json) {
        Either<DecodingFailure, String> jsonStr = json.as(Decoder$.MODULE$.decodeString());
        Either<DecodingFailure, String> either2 = jsonStr;
        if (!(either2 instanceof Right)) {
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                DecodingFailure error = (DecodingFailure)left.value();
                throw new SerializerException(error.getMessage(), SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
            }
            throw new MatchError(either2);
        }
        Right right = (Right)either2;
        String jsonStr2 = (String)right.value();
        byte[] byArray = ErgoAlgos$.MODULE$.decode(jsonStr2).get();
        return byArray;
    }

    private <T extends SType> Object decodeData(Json json, T tpe) {
        Object object;
        T t = tpe;
        if (SUnit$.MODULE$.equals(t)) {
            object = BoxedUnit.UNIT;
        } else if (SBoolean$.MODULE$.equals(t)) {
            object = json.asBoolean().get();
        } else if (SByte$.MODULE$.equals(t)) {
            object = json.asNumber().get().toByte().get();
        } else if (SShort$.MODULE$.equals(t)) {
            object = json.asNumber().get().toShort().get();
        } else if (SInt$.MODULE$.equals(t)) {
            object = json.asNumber().get().toInt().get();
        } else if (SLong$.MODULE$.equals(t)) {
            object = json.asNumber().get().toLong().get();
        } else if (SBigInt$.MODULE$.equals(t)) {
            object = sigmastate.eval.package$.MODULE$.SigmaDsl().BigInt(new BigInteger(this.decodeBytes(json)));
        } else if (SString$.MODULE$.equals(t)) {
            object = new String(this.decodeBytes(json));
        } else if (t instanceof SCollectionType) {
            SCollectionType sCollectionType = (SCollectionType)t;
            Object tpeElem = sCollectionType.elemType();
            object = this.decodeColl(json, tpeElem);
        } else if (t instanceof SOption) {
            Option option;
            SOption sOption = (SOption)t;
            Json json2 = json;
            Json json3 = Json$.MODULE$.Null();
            if (!(json2 != null ? !((Object)json2).equals(json3) : json3 != null)) {
                option = None$.MODULE$;
            } else {
                Coll<Object> items = this.decodeColl(json, (T)sOption.elemType());
                option = new Some<Object>(items.apply(0));
            }
            object = option;
        } else if (t instanceof STuple) {
            STuple sTuple = (STuple)t;
            SType[] tArr = (SType[])sTuple.items().toArray(ClassTag$.MODULE$.apply(SType.class));
            if (tArr.length != 2) {
                throw new SerializerException("Tuples with length not equal to 2 are not supported", SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
            }
            ArrayBuilder<Object> collSource = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Any());
            for (int index$macro$1 = 1; index$macro$1 <= tArr.length; ++index$macro$1) {
                collSource.$plus$eq(this.decodeData(json.hcursor().downField(new StringBuilder(1).append("_").append(index$macro$1).toString()).focus().get(), tArr[index$macro$1 - 1]));
            }
            Coll<Object> coll = sigmastate.eval.package$.MODULE$.Colls().fromArray(collSource.result(), RType$.MODULE$.AnyType());
            object = Evaluation$.MODULE$.toDslTuple(coll, sTuple);
        } else if (SGroupElement$.MODULE$.equals(t)) {
            byte[] str = this.decodeBytes(json);
            SigmaByteReader r = SigmaSerializer$.MODULE$.startReader(str, SigmaSerializer$.MODULE$.startReader$default$2());
            object = DataSerializer$.MODULE$.deserialize(SGroupElement$.MODULE$, r);
        } else if (SAvlTree$.MODULE$.equals(t)) {
            byte[] str = this.decodeBytes(json);
            SigmaByteReader r = SigmaSerializer$.MODULE$.startReader(str, SigmaSerializer$.MODULE$.startReader$default$2());
            object = DataSerializer$.MODULE$.deserialize(SAvlTree$.MODULE$, r);
        } else if (SSigmaProp$.MODULE$.equals(t)) {
            byte[] str = this.decodeBytes(json);
            SigmaByteReader r = SigmaSerializer$.MODULE$.startReader(str, SigmaSerializer$.MODULE$.startReader$default$2());
            object = DataSerializer$.MODULE$.deserialize(SSigmaProp$.MODULE$, r);
        } else if (SBox$.MODULE$.equals(t)) {
            long value = BoxesRunTime.unboxToLong(this.decodeData(json.hcursor().downField("value").focus().get(), SLong$.MODULE$));
            Values.ErgoTree tree = ErgoTreeSerializer$.MODULE$.DefaultSerializer().deserializeErgoTree(this.decodeBytes(json.hcursor().downField("ergoTree").focus().get()));
            Coll<Tuple2<byte[], Object>> tokens = ((Coll)this.decodeData(json.hcursor().downField("tokens").focus().get(), new SCollectionType<STuple>(STuple$.MODULE$.apply((Seq<SType>)Predef$.MODULE$.wrapRefArray((Object[])new SType[]{new SCollectionType<SByte$>(SByte$.MODULE$), SLong$.MODULE$}))))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)v -> {
                Tuple2 tup = v;
                return new Tuple2<byte[], Long>(((Coll)tup._1()).toArray$mcB$sp(), BoxesRunTime.boxToLong(tup._2$mcJ$sp()));
            }, RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32RType(), RType$.MODULE$.LongType()));
            String txId = package$ByteArrayOps$.MODULE$.toModifierId$extension(package$.MODULE$.ByteArrayOps(this.decodeBytes(json.hcursor().downField("txId").focus().get())));
            short index = BoxesRunTime.unboxToShort(this.decodeData(json.hcursor().downField("index").focus().get(), SShort$.MODULE$));
            int creationHeight = BoxesRunTime.unboxToInt(this.decodeData(json.hcursor().downField("creationHeight").focus().get(), SInt$.MODULE$));
            MutableList additionalRegisters = (MutableList)MutableList$.MODULE$.empty();
            ErgoBox$.MODULE$.nonMandatoryRegisters().foreach((Function1<ErgoBox.NonMandatoryRegisterId, Object> & Serializable & scala.Serializable)register -> {
                Object object;
                Option<Json> opt = json.hcursor().downField(new StringBuilder(1).append("r").append(register.number()).toString()).focus();
                if (opt.isDefined() && !opt.get().isNull()) {
                    Tuple2<Object, SType> tuple2 = MODULE$.decodeWithTpe(opt.get());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Object decoded = tuple2._1();
                    SType tpe = tuple2._2();
                    Tuple2<Object, SType> tuple22 = new Tuple2<Object, SType>(decoded, tpe);
                    Tuple2<Object, SType> tuple23 = tuple22;
                    Object decoded2 = tuple23._1();
                    SType tpe2 = tuple23._2();
                    object = additionalRegisters.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(register), Values$Constant$.MODULE$.apply(decoded2, tpe2)));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            object = sigmastate.eval.package$.MODULE$.SigmaDsl().Box(new ErgoBox(value, tree, tokens, (Map<ErgoBox.NonMandatoryRegisterId, ? extends Values.EvaluatedValue<? extends SType>>)additionalRegisters.toMap(Predef$.MODULE$.$conforms()), txId, index, creationHeight));
        } else {
            throw new SerializerException(new StringBuilder(36).append("Not defined DataSerializer for type ").append(t).toString(), SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
        }
        BoxedUnit res = object;
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private <T extends SType> Coll<Object> decodeColl(Json json, T tpe) {
        var7_3 = false;
        var8_4 = null;
        var9_5 = tpe;
        if (!(var9_5 instanceof STuple)) ** GOTO lbl-1000
        var7_3 = true;
        var8_4 = (STuple)var9_5;
        if (var8_4.items().length() == 2) {
            var5_6 = Evaluation$.MODULE$.stypeToRType(tpe);
        } else lbl-1000:
        // 2 sources

        {
            if (var7_3) {
                throw new SerializerException("Tuples with length not equal to 2 are not supported", SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
            }
            var5_6 = Evaluation$.MODULE$.stypeToRType(tpe);
        }
        tItem = var5_6;
        var10_8 = tpe;
        if (var10_8 instanceof STuple) {
            var11_9 = (STuple)var10_8;
            tArr = (SType[])var11_9.items().toArray(ClassTag$.MODULE$.apply(SType.class));
            collSource = ArrayBuilder$.MODULE$.make(tItem.classTag());
            leftColl = this.decodeColl(json.hcursor().downField("_1").focus().get(), tArr[0]);
            rightColl = this.decodeColl(json.hcursor().downField("_2").focus().get(), tArr[1]);
            Predef$.MODULE$.assert(leftColl.length() == rightColl.length());
            var3_14 = sigmastate.eval.package$.MODULE$.SigmaDsl().Colls().pairColl(leftColl, rightColl);
        } else {
            jsonList = json.as(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeJson()));
            var17_16 = jsonList;
            if (!(var17_16 instanceof Right)) {
                if (var17_16 instanceof Left) {
                    var21_21 = (Left)var17_16;
                    error = (DecodingFailure)var21_21.value();
                    throw new SerializerException(error.getMessage(), SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
                }
                throw new MatchError(var17_16);
            }
            var18_17 = (Right)var17_16;
            jsonList = (List)var18_17.value();
            collSource = ArrayBuilder$.MODULE$.make(tItem.classTag());
            jsonList.foreach((Function1<Json, ArrayBuilder> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeColl$1(scala.collection.mutable.ArrayBuilder sigmastate.SType io.circe.Json ), (Lio/circe/Json;)Lscala/collection/mutable/ArrayBuilder;)(collSource, tpe));
            var4_20 = sigmastate.eval.package$.MODULE$.Colls().fromArray(collSource.result(), tItem);
            var3_14 = var4_20;
        }
        return var3_14;
    }

    private Tuple2<Object, SType> decodeWithTpe(Json json) {
        SType tpe = SigmaParser$.MODULE$.parseType(json.hcursor().downField("type").focus().get().asString().get());
        Json value = json.hcursor().downField("value").focus().get();
        Object data = this.decodeData(value, tpe);
        return new Tuple2<Object, SType>(data, tpe);
    }

    /*
     * WARNING - void declaration
     */
    public Object decode(Json json) {
        void var3_5;
        Object data;
        Tuple2<Object, SType> tuple2 = this.decodeWithTpe(json);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object object = data = tuple2._1();
        Object data2 = object;
        return var3_5;
    }

    public AnyValue decodeAnyValue(Json json) {
        SType tpe = SigmaParser$.MODULE$.parseType(json.hcursor().downField("type").focus().get().asString().get());
        Json value = json.hcursor().downField("value").focus().get();
        Object data = this.decodeData(value, tpe);
        return new TestValue<Object>(data, Evaluation$.MODULE$.stypeToRType(tpe));
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$decodeColl$1(ArrayBuilder collSource$1, SType tpe$1, Json i) {
        return (ArrayBuilder)collSource$1.$plus$eq(MODULE$.decodeData(i, tpe$1));
    }

    private DataJsonEncoder$() {
        MODULE$ = this;
    }
}

