/*
 * Decompiled with CFR 0.152.
 */
package scorex.crypto.signatures;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.lang.reflect.Constructor;
import org.whispersystems.curve25519.OpportunisticCurve25519Provider;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.util.Failure;
import scala.util.Try$;
import scorex.crypto.hash.Sha256$;
import scorex.crypto.signatures.EllipticCurveSignatureScheme;
import scorex.crypto.signatures.SigningFunctions;
import scorex.crypto.signatures.package$PrivateKey$;
import scorex.crypto.signatures.package$PublicKey$;
import scorex.crypto.signatures.package$SharedSecret$;
import scorex.crypto.signatures.package$Signature$;
import scorex.util.ScorexLogging;
import supertagged.package$Tagger$;

public final class Curve25519$
implements EllipticCurveSignatureScheme,
ScorexLogging {
    public static Curve25519$ MODULE$;
    private final int SignatureLength25519;
    private final int KeyLength25519;
    private final int SignatureLength;
    private final int KeyLength;
    private final OpportunisticCurve25519Provider provider;
    private final Logger logger;

    static {
        new Curve25519$();
    }

    @Override
    public Logger log() {
        return ScorexLogging.log$(this);
    }

    @Override
    public Tuple2<byte[], byte[]> createKeyPair() {
        return SigningFunctions.createKeyPair$(this);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int SignatureLength25519() {
        return this.SignatureLength25519;
    }

    public int KeyLength25519() {
        return this.KeyLength25519;
    }

    @Override
    public int SignatureLength() {
        return this.SignatureLength;
    }

    @Override
    public int KeyLength() {
        return this.KeyLength;
    }

    private OpportunisticCurve25519Provider provider() {
        return this.provider;
    }

    @Override
    public Tuple2<byte[], byte[]> createKeyPair(byte[] seed) {
        byte[] hashedSeed = Sha256$.MODULE$.hash(seed);
        byte[] privateKey = (byte[])package$PrivateKey$.MODULE$.$at$at(this.provider().generatePrivateKey(hashedSeed), package$Tagger$.MODULE$.baseRaw());
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(privateKey), package$PublicKey$.MODULE$.$at$at(this.provider().generatePublicKey(privateKey), package$Tagger$.MODULE$.baseRaw()));
    }

    @Override
    public byte[] sign(byte[] privateKey, byte[] message) {
        Predef$.MODULE$.require(privateKey.length == this.KeyLength());
        return (byte[])package$Signature$.MODULE$.$at$at(this.provider().calculateSignature(this.provider().getRandom(this.SignatureLength()), privateKey, message), package$Tagger$.MODULE$.baseRaw());
    }

    @Override
    public boolean verify(byte[] signature, byte[] message, byte[] publicKey) {
        return BoxesRunTime.unboxToBoolean(Try$.MODULE$.apply((JFunction0$mcZ$sp & Serializable)() -> {
            Predef$.MODULE$.require(signature.length == MODULE$.SignatureLength());
            Predef$.MODULE$.require(publicKey.length == MODULE$.KeyLength());
            return MODULE$.provider().verifySignature(publicKey, message, signature);
        }).recoverWith(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (Curve25519$.MODULE$.log().underlying().isDebugEnabled()) {
                    Curve25519$.MODULE$.log().underlying().debug("Error while message signature verification", A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure<T> failure = new Failure<T>(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }).getOrElse((JFunction0$mcZ$sp & Serializable)() -> false));
    }

    @Override
    public byte[] createSharedSecret(byte[] privateKey, byte[] publicKey) {
        return (byte[])package$SharedSecret$.MODULE$.$at$at(this.provider().calculateAgreement(privateKey, publicKey), package$Tagger$.MODULE$.baseRaw());
    }

    private Curve25519$() {
        MODULE$ = this;
        SigningFunctions.$init$(this);
        StrictLogging.$init$(this);
        ScorexLogging.$init$(this);
        this.SignatureLength25519 = 64;
        this.KeyLength25519 = 32;
        this.SignatureLength = this.SignatureLength25519();
        this.KeyLength = this.KeyLength25519();
        Constructor constructor = (Constructor)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])OpportunisticCurve25519Provider.class.getDeclaredConstructors())).head();
        constructor.setAccessible(true);
        this.provider = (OpportunisticCurve25519Provider)constructor.newInstance(new Object[0]);
    }
}

