/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Randomness and commitment for the first step of the Schnorr protocol")
public class DlogCommitment {
    @SerializedName(value="r")
    private String r = null;
    @SerializedName(value="a")
    private String a = null;

    public DlogCommitment r(String string) {
        this.r = string;
        return this;
    }

    @Schema(example="433080ff80d0d52d7f8bfffff47f00807f44f680000949b800007f7f7ff1017f", required=true, description="Hex-encoded big-endian 256-bits secret exponent")
    public String getR() {
        return this.r;
    }

    public void setR(String string) {
        this.r = string;
    }

    public DlogCommitment a(String string) {
        this.a = string;
        return this;
    }

    @Schema(example="02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required=true, description="Hex-encoded \"g\" generator for the Diffie-Hellman tuple (secp256k1 curve point)")
    public String getA() {
        return this.a;
    }

    public void setA(String string) {
        this.a = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DlogCommitment dlogCommitment = (DlogCommitment)object;
        return Objects.equals(this.r, dlogCommitment.r) && Objects.equals(this.a, dlogCommitment.a);
    }

    public int hashCode() {
        return Objects.hash(this.r, this.a);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class DlogCommitment {\n");
        stringBuilder.append("    r: ").append(this.toIndentedString(this.r)).append("\n");
        stringBuilder.append("    a: ").append(this.toIndentedString(this.a)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

