/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.UnsignedErgoLikeTransaction;
import org.ergoplatform.appkit.ExtendedInputBox;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext;

public class UnsignedTransactionImpl
implements UnsignedTransaction {
    private final UnsignedErgoLikeTransaction _tx;
    private List<ExtendedInputBox> _boxesToSpend;
    private List<ErgoBox> _dataBoxes;
    private List<ErgoBoxCandidate> _outputs;
    private ErgoAddress _changeAddress;
    private ErgoLikeStateContext _stateContext;
    private BlockchainContextImpl _ctx;

    public UnsignedTransactionImpl(UnsignedErgoLikeTransaction unsignedErgoLikeTransaction, List<ExtendedInputBox> list, List<ErgoBox> list2, List<ErgoBoxCandidate> list3, ErgoAddress ergoAddress, ErgoLikeStateContext ergoLikeStateContext, BlockchainContextImpl blockchainContextImpl) {
        this._tx = unsignedErgoLikeTransaction;
        this._boxesToSpend = list;
        this._dataBoxes = list2;
        this._outputs = list3;
        this._changeAddress = ergoAddress;
        this._stateContext = ergoLikeStateContext;
        this._ctx = blockchainContextImpl;
    }

    public UnsignedErgoLikeTransaction getTx() {
        return this._tx;
    }

    public List<ExtendedInputBox> getBoxesToSpend() {
        return this._boxesToSpend;
    }

    public List<ErgoBox> getDataBoxes() {
        return this._dataBoxes;
    }

    public ErgoLikeStateContext getStateContext() {
        return this._stateContext;
    }

    @Override
    public List<InputBox> getInputs() {
        return this._boxesToSpend.stream().map(extendedInputBox -> new InputBoxImpl((BlockchainContextBase)this._ctx, extendedInputBox.box())).collect(Collectors.toList());
    }

    @Override
    public List<OutBox> getOutputs() {
        return this._outputs.stream().map(ergoBoxCandidate -> new OutBoxImpl(this._ctx, (ErgoBoxCandidate)ergoBoxCandidate)).collect(Collectors.toList());
    }

    @Override
    public List<InputBox> getDataInputs() {
        return this._dataBoxes.stream().map(ergoBox -> new InputBoxImpl((BlockchainContextBase)this._ctx, (ErgoBox)ergoBox)).collect(Collectors.toList());
    }

    @Override
    public ErgoAddress getChangeAddress() {
        return this._changeAddress;
    }
}

