/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.ErgoLikeTransactionSerializer$;
import org.ergoplatform.Input;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.SignedInput;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.appkit.impl.SignedInputImpl;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.JSON;
import sigmastate.Values;
import sigmastate.serialization.SigmaSerializer$;
import sigmastate.utils.SigmaByteWriter;

public class SignedTransactionImpl
implements SignedTransaction {
    private final BlockchainContextBase _ctx;
    private final ErgoLikeTransaction _tx;
    private final int _txCost;

    public SignedTransactionImpl(BlockchainContextBase blockchainContextBase, ErgoLikeTransaction ergoLikeTransaction, int n) {
        this._ctx = blockchainContextBase;
        this._tx = ergoLikeTransaction;
        this._txCost = n;
    }

    public ErgoLikeTransaction getTx() {
        return this._tx;
    }

    public String toString() {
        return "Signed(" + this._tx + ")";
    }

    @Override
    public String getId() {
        return this._tx.id();
    }

    @Override
    public String toJson(boolean bl) {
        return this.toJson(bl, true);
    }

    @Override
    public String toJson(boolean bl, boolean bl2) {
        ErgoTransaction ergoTransaction = ScalaBridge.isoErgoTransaction().from(this._tx);
        if (bl) {
            for (ErgoTransactionOutput object2 : ergoTransaction.getOutputs()) {
                Values.ErgoTree ergoTree = ScalaBridge.isoStringToErgoTree().to(object2.getErgoTree());
                object2.ergoTree(ergoTree.toString());
            }
        }
        Gson gson = bl || bl2 ? JSON.createGson().setPrettyPrinting().create() : this._ctx.getApiClient().getGson();
        String string = gson.toJson(ergoTransaction);
        return string;
    }

    @Override
    public List<SignedInput> getSignedInputs() {
        List list = Iso.JListToIndexedSeq(Iso.identityIso()).from(this._tx.inputs());
        ArrayList<SignedInput> arrayList = new ArrayList<SignedInput>(list.size());
        for (Input input : list) {
            arrayList.add(new SignedInputImpl(this, input));
        }
        return arrayList;
    }

    @Override
    public List<InputBox> getOutputsToSpend() {
        List list = Iso.JListToIndexedSeq(Iso.identityIso()).from(this._tx.outputs());
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>(list.size());
        for (ErgoBox ergoBox : list) {
            arrayList.add(new InputBoxImpl(this._ctx, ergoBox));
        }
        return arrayList;
    }

    @Override
    public int getCost() {
        return this._txCost;
    }

    @Override
    public byte[] toBytes() {
        SigmaByteWriter sigmaByteWriter = SigmaSerializer$.MODULE$.startWriter();
        ErgoLikeTransactionSerializer$.MODULE$.serialize(this._tx, sigmaByteWriter);
        sigmaByteWriter.putUInt(this._txCost);
        return sigmaByteWriter.toBytes();
    }

    public int hashCode() {
        return 31 * this._tx.hashCode() + this._txCost;
    }

    public boolean equals(Object object) {
        if (object instanceof SignedTransactionImpl) {
            SignedTransactionImpl signedTransactionImpl = (SignedTransactionImpl)object;
            return Objects.equals(signedTransactionImpl._tx, this._tx) && signedTransactionImpl._txCost == this._txCost;
        }
        return false;
    }
}

