/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BoxOperations;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ErgoNodeFacade;
import org.ergoplatform.appkit.impl.ExplorerFacade;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.explorer.client.model.OutputInfo;
import org.ergoplatform.explorer.client.model.TransactionInfo;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionInput;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.Transactions;

public class ExplorerAndPoolUnspentBoxesLoader
extends BoxOperations.ExplorerApiWithCheckerLoader {
    private final List<String> unconfirmedSpentBoxesIds = new ArrayList<String>();
    private boolean unconfirmedBoxesFetched;
    private boolean allowChainedTx = false;

    public ExplorerAndPoolUnspentBoxesLoader withAllowChainedTx(boolean bl) {
        this.allowChainedTx = bl;
        return this;
    }

    @Override
    public void prepare(@Nonnull BlockchainContext blockchainContext, List<Address> list, long l, @Nonnull List<ErgoToken> list2) {
        if (!(blockchainContext instanceof BlockchainContextImpl)) {
            throw new IllegalArgumentException("This loader needs to be used with BlockchainContextImpl");
        }
        this.unconfirmedSpentBoxesIds.clear();
        Transactions transactions = ErgoNodeFacade.getUnconfirmedTransactions(((BlockchainContextImpl)blockchainContext).getRetrofit(), 1000, 0);
        for (ErgoTransaction ergoTransaction : transactions) {
            for (ErgoTransactionInput ergoTransactionInput : ergoTransaction.getInputs()) {
                this.unconfirmedSpentBoxesIds.add(ergoTransactionInput.getBoxId());
            }
        }
    }

    @Override
    public void prepareForAddress(Address address) {
        this.unconfirmedBoxesFetched = false;
    }

    @Override
    protected boolean canUseBox(InputBox inputBox) {
        return !this.unconfirmedSpentBoxesIds.contains(inputBox.getId().toString());
    }

    @Override
    @Nonnull
    public List<InputBox> loadBoxesPage(@Nonnull BlockchainContext blockchainContext, @Nonnull Address address, @Nonnull Integer n) {
        List<InputBox> list = super.loadBoxesPage(blockchainContext, address, n);
        if (list.isEmpty() && this.allowChainedTx && !this.unconfirmedBoxesFetched) {
            this.unconfirmedBoxesFetched = true;
            try {
                String string = address.toString();
                BlockchainContextImpl blockchainContextImpl = (BlockchainContextImpl)blockchainContext;
                List<TransactionInfo> list2 = ExplorerFacade.getApiV1MempoolTransactionsByaddressP1(blockchainContextImpl.getRetrofitExplorer(), string, 0, 50);
                for (TransactionInfo transactionInfo : list2) {
                    for (OutputInfo outputInfo : transactionInfo.getOutputs()) {
                        ErgoTransactionOutput ergoTransactionOutput;
                        if (!outputInfo.getAddress().equals(string) || outputInfo.getSpentTransactionId() != null || (ergoTransactionOutput = ErgoNodeFacade.getBoxWithPoolById(((BlockchainContextImpl)blockchainContext).getRetrofit(), outputInfo.getBoxId())) == null) continue;
                        list.add(new InputBoxImpl((BlockchainContextBase)blockchainContextImpl, ergoTransactionOutput));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }
}

